# @cnri/encoding

A JavaScript library for encoding and decoding between strings and byte arrays, including Base64, Hex, UTF-8, and UTF-16. This library can be used in both browser and Node.js environments.

## Usage

### Base64

```javascript
// Standard encoding
const bytes = new Uint8Array([104, 101, 108, 108, 111]);
const base64 = Base64.encode(bytes); // "aGVsbG8="

// URL-safe encoding
const urlSafeBase64 = Base64.encodeUrlSafe(bytes); // "aGVsbG8"

// Decoding (works with both standard and URL-safe Base64)
const decodedBytes = Base64.decode(base64);
const decodedUrlSafeBytes = Base64.decode(urlSafeBase64);
```

### Hex

```javascript
// Encoding
const bytes = new Uint8Array([104, 101, 108, 108, 111]);
const hex = Hex.encode(bytes); // "68656C6C6F"

// Decoding (case-insensitive)
const decodedBytes = Hex.decode("68656c6c6f");
```

### UTF-8

```javascript
// Converting string to UTF-8 bytes
const bytes = Utf8.toBytes("hello");

// Converting UTF-8 bytes to string
const str = Utf8.toString(bytes);

// Checking if bytes likely contain binary data
const isBinary = Utf8.looksLikeBinary(bytes);

// Checking if string likely contains binary data
const stringIsBinary = Utf8.stringLooksLikeBinary(str);
```

### UTF-16

```javascript
// Converting string to UTF-16 bytes
const bytes = Utf16.toBytes("hello");

// Converting UTF-16 bytes to string
const str = Utf16.toString(bytes);
```
